/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskHistory;
import com.ibm.hsc.iw.WizardTaskInterface;
import java.util.ArrayList;
import java.util.Iterator;

public class WizardTasksHistory {
    private static final String TRACE_MASKD = "JIWZWTSD";
    private static final String TRACE_MASKF = "JIWZWTSF";
    private static final String TRACE_MASKT = "JIWZWTST";
    private ArrayList tasks = new ArrayList();
    private boolean committed = false;
    private boolean rebootRequired = false;
    private boolean reLogonRequired = false;

    WizardTasksHistory() {
    }

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    int size() {
        return this.tasks.size();
    }

    WizardTaskHistory get(int n) throws IndexOutOfBoundsException {
        return (WizardTaskHistory)this.tasks.get(n);
    }

    void add(WizardTaskHistory wizardTaskHistory) {
        this.tasks.add(wizardTaskHistory);
    }

    public String toString() {
        StringBuffer stringBuffer = null;
        WizardTaskHistory wizardTaskHistory = null;
        stringBuffer = new StringBuffer();
        if (this.tasks == null || this.tasks.size() == 0) {
            stringBuffer.append("no task histories");
        } else {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                wizardTaskHistory = (WizardTaskHistory)iterator.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("task of ");
                stringBuffer.append(wizardTaskHistory);
            }
        }
        return stringBuffer.toString();
    }

    void setCommitted(boolean bl) {
        this.committed = bl;
    }

    boolean isCommitted() {
        return this.committed;
    }

    void setRebootRequired(boolean bl) {
        this.rebootRequired = bl;
    }

    boolean isRebootRequired() {
        return this.rebootRequired;
    }

    void setReLogonRequired(boolean bl) {
        this.reLogonRequired = bl;
    }

    boolean isReLogonRequired() {
        return this.reLogonRequired;
    }

    WizardTaskInterface getTask(Class clazz) {
        WizardTaskInterface wizardTaskInterface = null;
        WizardTaskHistory wizardTaskHistory = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->getTask(" + clazz + ")");
        }
        if (this.tasks != null) {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                wizardTaskHistory = (WizardTaskHistory)iterator.next();
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "comparing " + wizardTaskHistory.getTask().getClass().getName() + " to " + clazz.getName());
                }
                if (!wizardTaskHistory.getTask().getClass().getName().equals(clazz.getName())) continue;
                wizardTaskInterface = wizardTaskHistory.getTask();
                break;
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-getTask(...) returning " + wizardTaskInterface);
        }
        return wizardTaskInterface;
    }
}

